# Comment cloné une carte SCHC Sur Une Autre dans Unbuntu server 24 LTD sans desktop

Pour cloner une carte SD/SHDC sur une autre sous Ubuntu Server 24.04 LTS sans interface graphique, 
	le plus simple est d’utiliser la ligne de commande avec `dd` ou 
	une combinaison `lsblk` + `dd` + éventuellement `fsck` et `resize2fs` si la carte cible est plus grande.

## Principe général

L’idée est de copier bloc à bloc tout le contenu de la carte source vers la carte cible, 
	en prenant garde à bien identifier les bons périphériques (`/dev/sdX` ou `/dev/mmcblkX`). 

	Cette méthode crée un clone exact (table de partitions, bootloader, système de fichiers, etc.).

--------------------------------------------------------------------------

## Étape 1 : identifier source et destination

1. Insérer les deux cartes (via adaptateurs USB si besoin).
2. Lister les disques :

```bash

lsblk -p

```

Repérer par exemple :

    - Source : `/dev/sdb`
    - Cible : `/dev/sdc`

* * * Ne pas se tromper : la cible sera entièrement écrasée.

*************************************************************************

## Étape 2 : démonter les partitions

Avant de cloner, démonter toutes les partitions montées des deux cartes :

```bash

sudo umount /dev/sdb1 /dev/sdb2  # adapter avec 2 Partitions
sudo umount /dev/sdc1 /dev/sdc2  # adapter avec 2 Partitions

```

Cela évite la corruption pendant la copie.

--------------------------------------------------------------------------

## Étape 3 : clonage avec dd

Commande typique :

```bash

sudo dd if=/dev/sdb of=/dev/sdc bs=10M status=progress conv=fsync

```

- `if` = input file = 	carte source.  Ex: sdb
- `of` = output file = 	carte cible.  Ex: sdc
- `bs=10M` 				améliore la vitesse, 
- `status=progress` 	affiche l’avancement, 
- `conv=fsync` 			force l’écriture sur le disque.

Attendre la fin, puis forcer le flush :

```bash

sync

```

La carte cible est maintenant une copie bit à bit de la source.

--------------------------------------------------------------------------

## Étape 4 : gérer la taille différente (optionnel)

Si la carte cible est plus grande que la source, il restera de l’espace non utilisé. 
	Deux options :

- Utiliser `gparted` 	depuis une autre machine linux graphique. ( avec desktop )
- Ou, en console : 		pour server linux (sans desktop )

1. Lancer `sudo fdisk /dev/sdc` ou `sudo parted /dev/sdc` pour agrandir la dernière partition.
2. Puis, si c’est du ext4 par exemple :

```bash

sudo e2fsck -f /dev/sdc2
sudo resize2fs /dev/sdc2

```

Cela étend le système de fichiers pour utiliser tout l’espace.

--------------------------------------------------------------------------

## Étape 5 : vérification et premier boot

1. Refaire `lsblk -p` pour vérifier la table de partitions.

2. Monter la carte clonée pour vérifier le contenu :

```bash

sudo mount /dev/sdc1 /mnt
ls /mnt
sudo umount /mnt

```

3. Tester ensuite le boot sur la machine cible ; 
	si les deux cartes restent branchées sur la même machine, 
	** attention aux UUID identiques ** qui peuvent perturber `fstab` ou le bootloader.

